﻿#target indesign
var w = new Window('dialog {text: "Batch Export/Packaging Preferences", orientation: "column", alignChildren:["fill","fill"], properties: {closeButton: false}}');
var options = {};
w.main = w.add('group {preferredSize: [600, 500], alignChildren: ["left","fill"]}');
w.stubs = w.main.add('listbox', undefined, ['1. Preflight', '2.1. Input/Output','2.2 Preferences']);
w.stubs.preferredSize.width = 150;
w.tabGroup = w.main.add('group {alignment: ["fill","fill"], orientation: "stack"}');
w.tabs = [];
// Preflight
    w.tabs[0] = w.tabGroup.add('group');
    w.tabs[0].add('statictext {text: "Preflight"}');
    w.tabs[0].add('panel');
    var preflightTab = w.tabs[0].add('panel {text: " ", preferredSize: [-1, 80]}');
    preflightTab.alignChildren = "left";
    preflightTab.add('statictext{text:"Check your document for errors"}');
    preflightTab.buttons = preflightTab.add('group {alignment: ["fill","fill"]}');
	      preflightTab.dummy =preflightTab.add('group');
           var list = preflightTab.dummy.add ('listbox', undefined, undefined, {
                numberOfColumns: 3, 
                showHeaders: true, 
                columnTitles: ['Type', 'Message', 'Location'],
                columnWidths: [50, 350, 70], 
                multiselect: true
            });		
            list.minimumSize.height = 450;
            list.minimumSize.width = 500;
            preflightTab.buttons = preflightTab.add ('group');			
            var startPreflight = preflightTab.buttons.add('button {text: "Start Preflight"}');
            startPreflight.onClick = function () {
                preflightDocument(list);
            }
//
// Input/Output locations
w.tabs[1] = w.tabGroup.add('group');
w.tabs[1].add('statictext {text: "Export locations"}');
w.tabs[1].add('panel');
var inputTab = w.tabs[1].add('panel {text: "Input ", preferredSize: [-1, 80]}');
var outputTab = w.tabs[1].add('panel {text: "Output", preferredSize: [-1, 80]}');

inputTab.alignChildren = "left";
inputTab.add('statictext{text:"Choose Input folder"}');
var folderInput = inputTab.add('edittext', undefined);
folderInput.preferredSize.width = 400;
inputTab.buttons = inputTab.add('group {alignment: ["fill","fill"], orientation:["fill","fill"]}');
var openInput = inputTab.buttons.add('button {text: "Open"}');
openInput.onClick = function () {
    var folderIn = Folder.selectDialog("Select a folder with InDesign files");
    folderInput.value = folderIn.fsName;
    folderInput.text = folderIn.absoluteURI;
    w.inValue = folderInput.value;
    options.input = w.inValue;
}
outputTab.alignChildren = "left";
outputTab.add('statictext{text:"Choose Output folder"}');
var outputFolder = outputTab.add('edittext', undefined, '');
outputFolder.preferredSize.width = 400;
outputTab.buttons = outputTab.add('group {alignment: ["fill","fill"], orientation:["fill","fill"]}');
var openOutput = outputTab.buttons.add('button {text: "Open"}');
openOutput.onClick = function () {
    var folderOut = Folder.selectDialog("Select a folder with InDesign files");
    outputFolder.value = folderOut.absoluteURI;
    outputFolder.text = folderOut.absoluteURI.toString();
    w.outValue = outputFolder.value;
    options.output = w.outValue;
}
//  End Input/Output locations
// General export preferences
w.tabs[2] = w.tabGroup.add('group');
w.tabs[2].add('statictext {text: "General"}');
w.tabs[2].add('panel');
var writeErrors = w.tabs[2].add('checkbox {text: "Write errors to log"}');
var pdfTab = w.tabs[2].add('panel {text: "PDF", preferredSize: [-1, 80]}');
var packageTab = w.tabs[2].add('panel {text: "Package", preferredSize: [-1, 80]}');
var imagesTab = w.tabs[2].add('panel {text: "Image preferences", preferredSize: [-1, 150]}');
//start export tab
var exportTab = w.tabs[2].add('panel {text: "Export preferences", preferredSize: [-1, 150]}');
var includeZip = exportTab.add("checkbox", undefined, "Zip package (Note: experimental function only for WINDOWS)");
includeZip.value = false;
var includeOriginals = exportTab.add("checkbox", undefined, "Keep original packages");
includeOriginals.value = false;
exportTab.alignChildren = "left";
// end export tab
var showBleedMarks = pdfTab.add("checkbox", undefined, "IncludeBleed");
showBleedMarks.value = false;
pdfTab.alignChildren = "left";
// add pdf presets options
var arr = [];
for(var i in PDFXStandards){
    var type = PDFXStandards[i];
    arr.push(type);
}
var pdfPresets = arr;
pdfTab.add('statictext{text:"PDF Standard Compliance: "}');
var pdfStandard = pdfTab.add('dropdownlist', undefined,pdfPresets);
pdfStandard.selection = 5;
// add package preferences
packageTab.alignChildren = "left";
packageTab.orientation = "row";
var fonts = packageTab.add("checkbox", undefined, "Include Fonts");
fonts.value = true;
fonts.enabled = false;
var links = packageTab.add("checkbox", undefined, "Include Links");
links.value = true;
links.enabled = false;
var png = packageTab.add("checkbox", undefined, "Include Png");
png.value = true;
png.enabled = false;


//add image preferences
imagesTab.alignChildren = "left";
imagesTab.add('statictext{text:"Choose image resolution(ppi):"}');
var resolutionSelect = imagesTab.add('dropdownlist', undefined, ['72', '96', '150', '300', '600', '1200', '2400']);
resolutionSelect.preferredSize.width = 100;
resolutionSelect.selection = 2;
var transparency = imagesTab.add("checkbox", undefined, "Use transparent background");
transparency.value = true;
// end image preferences
// End general export preferences
w.buttons =w.tabs[2] .add('group {alignment: ["center","center"]}');
w.okBtn = w.buttons.add('button {text: "Start Export"}');
w.cancelBtns = w.add('group');
w.cancelBtn = w.cancelBtns.add('button {text: "Cancel"}');
w.okBtn.onClick = function () {
    options.packageOptions = [];
    options.imageResolution = resolutionSelect.selection.text;
    options.useTransparency = transparency.value;
    options.showBleedMarks = showBleedMarks.value;
    options.includeZip = includeZip.value;
    options.includeOriginals = includeOriginals.value;
    options.includeFonts = fonts.value;
    options.includeLinks = links.value;
    options.writeErrors = writeErrors.value;
    options.standardPdf = pdfStandard.selection.text ;
    for (var i = 0; i < pdfTab.children.length; i++)
        if (pdfTab.children[i].value == true)
            options.pdfPreset = pdfTab.children[i].text;
    for (var i = 0; i < packageTab.children.length; i++)
        if (packageTab.children[i].value == true)
            options.packageOptions[i] = packageTab.children[i].text;
    if (typeof(w.outValue) == "undefined" || typeof(w.inValue) == "undefined") {
        alert("Please selet input/output locations");
    } else {
        w.close();
    }
}
w.cancelBtn.onClick = function () {
    options.stop = true;
    w.close();

}
for (var i = 0; i < w.tabs.length; i++) {
    w.tabs[i].orientation = 'column';
    w.tabs[i].alignChildren = 'fill';
    w.tabs[i].alignment = ['fill', 'fill'];
    w.tabs[i].visible = false;
}
w.stubs.onChange = showTab;
function showTab() {
    if (w.stubs.selection !== null) {
        for (var i = w.tabs.length - 1; i >= 0; i--) {
            w.tabs[i].visible = false;
        }
        w.tabs[w.stubs.selection.index].visible = true;
    }
}
w.onShow = function () {
    w.stubs.selection = 0;
    showTab;
}
w.show();
beginExport(options);
// start export functionality
function beginExport(options) {
    var start = Date.now();
        WriteToFile("\r--------------------- Script started -- " + GetDate() + " ---------------------\n");
    if (options.stop) {
        return;
    }
        var tempPreset = app.pdfExportPresets.item("tempPreset");
        try
        {
            tempPreset.name;
        }
        catch (eNoSuchPreset)
        {
            tempPreset = app.pdfExportPresets.add({name:"tempPreset"});
        }
        with (tempPreset)
        {
            cropMarks = false;
            bleedMarks = false;
            if (options.showBleedMarks) {
                useDocumentBleedWithPDF = true;
            }else{
                     useDocumentBleedWithPDF = false;
             }
             switch(options.standardPdf) {
                case "PDFX42010_STANDARD":
                    standardsCompliance = PDFXStandards.PDFX42010_STANDARD; 
                    break;
                 case "PDFX1A2001_STANDARD":
                     standardsCompliance = PDFXStandards.PDFX1A2001_STANDARD; 
                    break;
                 case "PDFX1A2003_STANDARD":
                     standardsCompliance = PDFXStandards.PDFX1A2003_STANDARD; 
                    break;
                  case "PDFX32002_STANDARD":
                     standardsCompliance = PDFXStandards.PDFX32002_STANDARD; 
                    break;   
                 case "PDFX32003_STANDARD":
                     standardsCompliance = PDFXStandards.PDFX32003_STANDARD; 
                    break;  
                  case "NONE":
                     standardsCompliance = PDFXStandards.NONE; 
                    break;  
                default:
                   standardsCompliance = PDFXStandards.PDFX42010_STANDARD; 
                   break;
            }      
        }
    var progressBarWindow = new Window('window', 'Packaging files');
    var outputFolder = options.output;
    try {
        if (options.input) {
            var inputFolder = Folder(options.input);
            var subfolders = inputFolder.getFiles();
               if(options.includeOriginals){             
                    var originalsFolder = new  Folder (options.input + "/originals/");
                     if(originalsFolder.exists){
                           originalsFolder = new Folder(originalsFolder +"_"+ parseInt ((Math.random() * (2000 - 10)) + 10));
                     }
            }
            var progressBar = progressBarWindow.add('progressbar', [12, 12, 350, 24], 0, subfolders.length);
            var progressBarTxt = progressBarWindow.add('statictext', undefined, 'Starting packaging files');
            progressBarTxt.bounds = [0, 0, 740, 30];
            progressBarTxt.alignment = "left";
            progressBarWindow.show();
            progressBarWindow.cancelButton = progressBarWindow.add('button', undefined, 'Close');
            progressBarWindow.cancelButton.onClick = function () {
                return progressBarWindow.exception = new Error('User canceled the pre-processing!');
            };
            var inddFilesCount = getAllInddFiles(subfolders);
            var indexFile = 1;
            for (var index = 0; index < subfolders.length; index++) {
                var myCurrentFolder = subfolders[index];       
                 if(options.includeOriginals){                 
                	copyFolder(myCurrentFolder, new Folder (originalsFolder + '/' + myCurrentFolder.name));  
                } 
                if(myCurrentFolder instanceof Folder)
                {              
                        var myInddFiles = myCurrentFolder.getFiles("*.indd");
                        for (indd_index = 0; indd_index < myInddFiles.length; indd_index++) {
                            indexFile++;
                            var myCurrentFile = myInddFiles[indd_index];
                            // add values to progress bar
                            progressBar.value = indexFile;
                            progressBarTxt.text = String("Packaging file - " + myCurrentFile.name + " (" + indexFile + " of " + inddFilesCount + " from folder " + myCurrentFolder.name + " ) ");
                            WriteToFile("Packaging file - " + myCurrentFile.name + "\n");
                            // end add values to progress bar
                            exportAndCreatePackage(myCurrentFile, outputFolder, options, tempPreset);
                        }
                }
            }
        }
        var end = Date.now();
        var diff = (end - start) / 1000.0;
        WriteToFile("\r--------------------- Script ended-- " + GetDate() + " ---------------------\n");
        WriteToFile("\r--------------------- Script finished in " + diff + " seconds---------------------\n");
    } catch (err) {
        WriteToFile("\r An error has occured " + err + "\n");
    }
}

function getAllInddFiles(subfolders) {
    var count = 1;
    for (var index = 0; index < subfolders.length; index++) {
        var myCurrentFolder = subfolders[index];
        if(myCurrentFolder instanceof Folder)
        {
            var myInddFiles = myCurrentFolder.getFiles("*.indd");
            for (indd_index = 0; indd_index < myInddFiles.length; indd_index++) {
                count++;
            }
        }
    }
    return count;
}

function exportAndCreatePackage(document, outputFolder, options,tempPreset) {
    var outputFolder = Folder(options.output);
    try {
        var myDoc = app.open(document, false);
        var myDocumentName = myDoc.name.slice(0, -5);
        // updating indesign file's links
        updateLinks(myDoc);
        //
        var inddFolderExport = new Folder(outputFolder + "/" + myDocumentName+"_"+ parseInt ((Math.random() * (2000 - 10)) + 10));
        var thumbnailFolder = new Folder(inddFolderExport + "/thumbnails");
        inddFolderExport.create();
        thumbnailFolder.create();
        var myFolderName = myDoc.filePath;
        var hasAdditional = false;
        for (i = 0; i < myDoc.layers.length; i++) {
            var currentLayer = myDoc.layers[i];
            if(currentLayer.name.indexOf('additional') !== -1){
                    hasAdditional = true;
                    break;
             }
    }
        var additional_folder = new Folder(inddFolderExport + "/additional/");
        if(hasAdditional){
            additional_folder.create();
        }
        var presets = options.pdfPreset;
        var myFilePath = inddFolderExport + "/" + myDocumentName + ".pdf";
        var myStaticFile = new File(myFilePath);
        createThumbnails(myDoc, thumbnailFolder, true);
        exportStaticPdf(myDoc, myStaticFile, presets, thumbnailFolder, tempPreset); //export static layers
        for (var layer_index = 1; layer_index < 5; layer_index++) {
            var additional_name = String("additional" + layer_index);
            if (myDoc.layers.item(additional_name).isValid) {
                exportAdditionalPdf(myDoc, layer_index, additional_folder, tempPreset); // export additional layers
                myDoc.layers.item(additional_name).visible = false;
            }
        }
        createPackage(myDoc, inddFolderExport); // create the package
        if(options.includeZip){
                var thisFile = new File($.fileName);
                var absPath = File($.fileName).parent.fsName;  
                var basePath = thisFile.path;
                var f = new File(basePath + '/zipShell.vbs');
                var destZip = inddFolderExport.parent.fsName + '\\'+inddFolderExport.name + '.zip';
                var toZip = inddFolderExport.parent.fsName + '\\'+inddFolderExport.name;
                app.doScript(f,ScriptLanguage.VISUAL_BASIC, [destZip,toZip,absPath,'zip.vbs']);
        }
        myDoc.close(SaveOptions.YES);
    } catch (err) {
        WriteToFile("\r An error has occured " + err + "\n");
    }
}
function createThumbnails(myDoc, thumbnailsFolder, thumbs) {
    if (options.useTransparency) {
        app.pngExportPreferences.transparentBackground = true;
    } else {
        app.pngExportPreferences.transparentBackground = false;
    }
    if (options.imageResolution) {
        app.pngExportPreferences.exportResolution = parseInt(options.imageResolution);
    }
    if (options.showBleedMarks) {
        app.pngExportPreferences.useDocumentBleeds = true;
    } else {
        app.pngExportPreferences.useDocumentBleeds = false;
    }
    if (thumbs) {
        var thumbPath = thumbnailsFolder + "/thumb.png";
    } else {
        var thumbPath = thumbnailsFolder + "/page_.png";
        app.pngExportPreferences.transparentBackground = false;
    }
    for (var myCounter = 0; myCounter < myDoc.pages.length; myCounter++) {
        thumb = new File(thumbPath);
        try {
            myDoc.exportFile(ExportFormat.pngFormat, thumb, false);
        } catch (err) {
            WriteToFile("\r Unable to create thumbnail for page -- " + myCounter + ' for file ' + myDoc.name + " ---------------------\n");
        }
    }
}
function exportStaticPdf(myDoc, myStaticFile, presets, thumbnailFolder,tempPreset) {
    hideAllLayers(myDoc);
    if (myDoc.layers.item("static").isValid) {
        myDoc.layers.item("static").visible = true;
    } else if (myDoc.layers.item("static1").isValid) {
        myDoc.layers.item("static1").visible = true;
    }
    try {
        myDoc.exportFile(ExportFormat.pdfType, myStaticFile, false, tempPreset);
        createThumbnails(myDoc, thumbnailFolder, false);
    } catch (err) {
        WriteToFile("\r An error has occured when trying to create the static pdf " + err + "\n");
    }
}
function exportAdditionalPdf(myDoc, layer_index, folder, tempPreset) {
    enableAllLayers(myDoc);
    hideAllLayers(myDoc);
    myDoc.layers.item("additional" + layer_index).visible = true;
    var myAdditionalPdfPath = folder + "/additional" + layer_index + ".pdf";
    var myAdditionalImagePath = folder + "/additional" + layer_index + ".png";
    var myAdditionalPdf = new File(myAdditionalPdfPath);
    var myAdditionalImage = new File(myAdditionalImagePath);
    // export additional layer as pdf (PDF/X-4 preset)
    try {
        myDoc.exportFile(ExportFormat.pdfType, myAdditionalPdf, false, tempPreset);
    } catch (err) {
        WriteToFile("\r An error has occured when trying to create the additional pdf " + err + "\n");
    }
    // export additional layer as png
    try {
        if (options.imageResolution) {
            app.pngExportPreferences.exportResolution = parseInt(options.imageResolution);
        }
        if (options.showBleedMarks) {
            app.pngExportPreferences.useDocumentBleeds = true;
        } else {
            app.pngExportPreferences.useDocumentBleeds = false;
        }
        if (options.useTransparency) {
            app.pngExportPreferences.transparentBackground = true;
        } else {
            app.pngExportPreferences.transparentBackground = false;
        }
        myDoc.exportFile(ExportFormat.pngFormat, myAdditionalImage, false);
    } catch (err) {
        WriteToFile("\r An error has occured when trying to create the additional images " + err + "\n");
    }
}

function enableAllLayers(myDoc) {
    for (i = 0; i < myDoc.layers.length; i++) {
        var currentLayer = myDoc.layers[i];
        currentLayer.visible = true;
    }
}

function hideAllLayers(myDoc) {
    for (i = 0; i < myDoc.layers.length; i++) {
        var currentLayer = myDoc.layers[i];
        currentLayer.visible = false;
    }
}
function updateLinks(myDoc) {
    var links = myDoc.links;
    var newPathLinks = myDoc.filePath + "/Links/";
    if (Folder(newPathLinks).exists) {
        for (var link_index = 0; link_index < links.length; link_index++) {
            var current_link = links[link_index];
            var newFile = new File(newPathLinks + current_link.name);
            if (newFile.exists) {
                current_link.relink(newFile);
                current_link.update();
            } else {
                WriteToFile("\r Unable to relink file -- " + current_link.name + " for " + myDoc.name + "\n");
            }
        }
    } else {
        WriteToFile("\r Links were not updated!! The Links folder does not exist for the file " + myDoc.name + "\n");
    }
}
function GetNameWithoutExtension(myFile) {
    var myFileName = myFile.name;
    var myIndex = myFileName.lastIndexOf(".");
    if (myIndex > -1) {
        myFileName = myFileName.substr(0, myIndex);
    }
    return myFileName;
}
function createPackage(myDoc, destination_folder) {
    for (i = 0; i < myDoc.layers.length; i++) {
        var currentLayer = myDoc.layers[i];
        if (currentLayer.name.indexOf("dynamic") == -1) {
            currentLayer.remove();
        }
    }
    try {
        myDoc.packageForPrint(destination_folder, true, true, true, true, true, true, true, true);
       
    } catch (err) {
        WriteToFile("\r Unable to package-- " + myDoc.name + " ---------------------\n");
    }
}

function WriteToFile(myText) {
    if(options.writeErrors){
        var reportFolder = Folder(options.output);
        myFile = new File(reportFolder + "/Package Report.txt");
        if (myFile.exists) {
            myFile.open("e");
            myFile.seek(0, 2);
        }
        else {
            myFile.open("w");
        }
        myFile.write(myText);
        myFile.close();
    }
}

function GetDate() {
    var myDate = new Date();
    return myDate.toLocaleString();
}
function copyFolder(sourceFolder, destinationFolder) {  
    if(sourceFolder instanceof Folder){
         var sourceChildrenArr = sourceFolder.getFiles();  
        for (var i = 0; i < sourceChildrenArr.length; i++) {  
            var sourceChild = sourceChildrenArr[i];  
            var destinationChildStr = destinationFolder.fsName + "/" + sourceChild.name;  
            if (sourceChild instanceof File) {  
                copyFile(sourceChild, new File(destinationChildStr));  
            }  
            else {  
                copyFolder(sourceChild, new Folder(destinationChildStr));  
            }  
        } 
    }
}  
  
  
function copyFile(sourceFile, destinationFile) {  
    createFolder(destinationFile.parent);  
    sourceFile.copy(destinationFile);  
}  
function createFolder(folder) {  
    if (folder.parent !== null && !folder.parent.exists) {  
        createFolder(folder.parent);  
    }  
    folder.create();  
} 

function getPreflightErrors(){
try{ 
        var doc = app.activeDocument;
        var docPages = doc.pages;
        var errorsByPage  ={};   
        var onPageObjects = [];		
        errorsByPage['fatal'] = [];
        errorsByPage['fatal'] = getFontError(doc);
        if(doc.documentPreferences.facingPages){              
                errorsByPage['fatal'].push({'type':'error', 'msg': 'Facing Pages are not supported.'});
        }       
        var layers = doc.layers;
        var dynamicLayers = [];
        for (var l=0; l <= layers.length; l++){
                var layer = layers[l];
                if(layer.isValid && layer.name.indexOf('dynamic')  !== -1 ){
                         var dname = layer.name;
                        dynamicLayers.push(dname);
               }
        }
        for (var l=0; l <= layers.length; l++){
                var layer = layers[l];
                if(layer.isValid && layer.name.indexOf('additional')  !== -1 ){
                        var dname = layer.name;
                        if( !dynamicLayerExists(doc,dname)){
                            errorsByPage['fatal'].push({'type':'error', 'msg': 'Dynamic layer '+ dname.replace('additional','dynamic') + ' is missing'});
                       }
               }
        }
         if(dynamicLayers.length == 0){
                 errorsByPage['fatal'].push({'type':'error', 'msg': 'No dynamic layers found in document.'})
         }
         for (var i=0; i< docPages.length;i++){
             errorsByPage['page_'+i] =[];
              var pageObjects = docPages[i].allPageItems;
              var polygonObjects = 0;
              var ovalObjects = 0;
              var groupObjects = 0;
              var unsupportedTypes = 0;
              var currentPage = docPages[i];
              var pageRotationAngle = GetSpreadRotation(currentPage);
              if(pageRotationAngle != 0 ){
                 errorsByPage['page_'+i].push({'type':'error', 'msg': 'Page ' + parseInt(currentPage.index + 1) + ' is rotated with: ' +pageRotationAngle});
             }
              for (var o = 0; o< pageObjects.length;o++){
                  var obj = pageObjects[o];
                  onPageObjects.push(obj.id);
                  var objLayer = obj.itemLayer;
                  if(objLayer.name.indexOf ("dynamic") != -1){
                        if(obj instanceof Polygon){
                              polygonObjects++;
                       } else if(obj instanceof Oval){
                           ovalObjects ++;
                       } else if(obj instanceof Rectangle){
                             errorsByPage['page_'+i] = getRectangleErrors(obj,  errorsByPage['page_'+i]);
                      }else if(obj instanceof TextFrame){
                             errorsByPage['page_'+i] = getTextFrameErrors (obj, errorsByPage['page_'+i]);
                      }else if(obj instanceof Image){}else{
                           if(obj instanceof Group){
                                groupObjects++;
                           }else{                           
                                unsupportedTypes++;
                            }
                      }
                 }
              }
                if(groupObjects > 0 ){
                     if(groupObjects ==1) {
                            var gMsg = '1 group found.';
                     }else{
                           var gMsg  =  groupObjects + 'groups  found. ';
                      }
                     errorsByPage['page_'+i] .push({'type': 'error', 'msg':  gMsg});
                }
                if(polygonObjects > 0 ){
                      if(polygonObjects ==1) {
                            var pMsg = '1 polygon object  found.';
                     }else{
                           var pMsg  =  polygonObjects + ' polygon objects found. ';
                      }
                    errorsByPage['page_'+i] .push({'type': 'error', 'msg':  pMsg});
                }
                if(ovalObjects > 0 ){
                     if(ovalObjects ==1) {
                            var oMsg = '1 oval object  found.';
                     }else{
                           var oMsg  =  ovalObjects + ' oval objects found. ';
                      }
                     errorsByPage['page_'+i] .push({'type': 'error', 'msg':  oMsg});
                }
                if(unsupportedTypes > 0 ){
                      if(unsupportedTypes ==1) {
                            var uMsg = '1 unsupported object  found.';
                     }else{
                           var uMsg  =  unsupportedTypes + '  unsupported objects found. ';
                      }
                     errorsByPage['page_'+i] .push({'type': 'error', 'msg':  uMsg});
                }
             }
         	var allObjects = doc.allPageItems;
			 var outsideObjects = 0;
			 for(var so = 0; so < allObjects.length; so++){
				var spreadObj = allObjects[so];
                    if(spreadObj.isValid){
                    	if(!inArray(onPageObjects, spreadObj.id)){
					var spreadObjjLayer = spreadObj.itemLayer;
					if(spreadObjjLayer.name.indexOf ("dynamic") != -1){
						outsideObjects++;
					}
				}
                 }			
			 }
			if(outsideObjects > 0){
                   if(outsideObjects == 1){
                        errorsByPage['fatal'].push({'type':'error','msg': outsideObjects+ ' object  found outside the page.'});
                  }else{
                       errorsByPage['fatal'].push({'type':'error','msg': outsideObjects+ ' objects  found outside the page.'});
                   } 				
			}
         return errorsByPage;
    }catch(err){
    }    
}
function additionalExists(doc, dynamicLayer){
       var layers = doc.layers;
        for (var l=0; l <= layers.length; l++){
                var layer = layers[l];
                if(layer.isValid && layer.name == dynamicLayer.replace("dynamic", "additional")){
                    return true;
               }
        }
    return false;
}
function dynamicLayerExists(doc, additionalLayer){
       var layers = doc.layers;
        for (var l=0; l <= layers.length; l++){
                var layer = layers[l];
                if(layer.isValid && layer.name == additionalLayer.replace("additional", "dynamic")){
                    return true;
               }
        }
    return false;
}
function preflightDocument(list){
          var errorsByPage = getPreflightErrors();
          var string = [];
             for(var pageKey in errorsByPage){
                 if(pageKey.indexOf ('fatal') !== -1){
                     var errorsPage = errorsByPage[pageKey];
                        for(var errorKey in errorsPage){
                           var errorObj = errorsPage[errorKey];
                           var errType = errorObj.type;
                           var errMsg = errorObj.msg;
                                string.push (errType.toUpperCase()  + ',' + errMsg+ ',' + 'Document');
                            }
                     }else{
                       var errorsPage = errorsByPage[pageKey];
                        for(var errorKey in errorsPage){
                           var errorObj = errorsPage[errorKey];
                           var errType = errorObj.type;
                           var errMsg = errorObj.msg;
                            var pag = pageKey.split('_');
                            var pagNo = parseInt (pag[1]) + 1;
                           string.push (errType.toUpperCase() + ',' + errMsg+ ',' + 'Page '+pagNo);
                     }              
                  }
             }

            var i, j, list_item, parts;
             list.removeAll();  
             if(string.length){
                for (i = 0; i < string.length; i++){
                    parts = string[i].split(',');
                    list_item = list.add ('item', parts[0]);
                    for (j = 1; j < parts.length; j++) {
                        list_item.subItems[j-1].text = parts[j];
                    }
                }
            }else{
               list.add ('item', 'No errors found');
            }    
}
    function getTextFrameErrors(obj, errors){
      var fontsUsedInFrame = [];
      var hasKerning = 0;
      var hasTextStroke= 0;
      var fontSizes =[];
      var horizonatalAlignements = [];
      var pColors = [];
      var  colorsUsed= [];
      var allowedParagraphStyles = ['[Basic Paragraph]','[No Paragraph Style]','[Einf. Abs.]'];
      if(typeof(obj.contents != "undefined")){
            var str = obj.contents;
            if(str.indexOf('\t') !== -1){
                  errors.push({'type': 'error', 'msg':  'You have tabs in you content.'});
            }    
      }
      if(typeof(obj.textWrapPreferences.textWrapMode) != "undefined" && obj.textWrapPreferences.textWrapMode  !== TextWrapModes.NONE){
                       errors.push({'type': 'error', 'msg':  'Text wrap used on text frame'});
       }
      for( var p=0; p<= obj.paragraphs.length; p++){
            var pr= obj.paragraphs[p];                             
            if(pr.isValid){ 
                if(!inArray(allowedParagraphStyles, pr.appliedParagraphStyle.name.toString())){
                    errors.push({'type': 'error', 'msg':  'Paragraph styles used in text frame.'});
                }
                if(pr.textStyleRanges.length){
                     for(var t=0; t <= pr.textStyleRanges.length; t++){
                         var ts =pr.textStyleRanges[t];
                         if(ts.isValid){
                                  if(typeof(ts.appliedFont)  == 'object' && ts.appliedFont instanceof Font){
                                      if(!inArray(fontsUsedInFrame, ts.appliedFont.name)){
                                           fontsUsedInFrame.push(ts.appliedFont.name);
                                      }                                                      
                                }else if( typeof ts.appliedFont == 'string'){
                                        if(fontsUsedInFrame.join(",").indexOf(ts.appliedFont) == -1){
                                           fontsUsedInFrame.push(ts.appliedFont);
                                         }
                                }
                                 if(ts.justification){
                                       if(horizonatalAlignements.join(",").indexOf(ts.justification) == -1){
                                            horizonatalAlignements.push(ts.justification);
                                       }
                                 }                                                
                                if(typeof(ts.kerningMethod) != 'undefined' && ts.kerningMethod == 'Manual' ){
                                    hasKerning++;                                                
                                }
                               if(typeof(ts.strokeColor) != 'undefined' && ts.strokeColor instanceof Color){
                                       hasTextStroke++;                                                
                               }
                                if(typeof(ts.pointSize) != "undefined"){
                                      if(!inArray (fontSizes, ts.pointSize)){
                                            fontSizes.push(ts.pointSize);
                                     }
                                }
                                if(typeof (ts.fillColor) !== "undefined" && ts.fillColor.isValid){
                                        if(!inArray(pColors, ts.fillColor.name)){
                                                pColors.push(ts.fillColor.name);
                                                colorsUsed.push({'name': ts.fillColor.name, 'space': ts.fillColor.space});
                                        }                                                           
                                }
                         }
                    }
                } 
               if(typeof(pr.strokeColor) != 'undefined' && pr.strokeColor instanceof Color ){
                      hasTextStroke++;                                                
                }
           
                if(pr.fillColor instanceof Color && typeof (pr.fillColor) !== "undefined" && pr.fillColor.isValid){
                        if(!inArray(pColors, pr.fillColor.name)){
                                pColors.push(pr.fillColor.name);
                                colorsUsed.push({'name': ts.fillColor.name, 'space': ts.fillColor.space});
                        }                                        
                }
                if(!inArray(horizonatalAlignements, pr.justification)){
                    horizonatalAlignements.push(pr.justification);
               }
                if(typeof(pr.pointSize) != "undefined"){
                      if(!inArray (fontSizes, pr.pointSize)){
                            fontSizes.push(pr.pointSize);
                     }
                }
                    if(typeof(pr.appliedFont)  == 'object' && pr.appliedFont instanceof Font){
                         var fontUsed = pr.appliedFont.name;
                    }else if( typeof pr.appliedFont == 'string'){
                           var fontUsed = pr.appliedFont;
                    } 
                   if(!inArray(fontsUsedInFrame, fontUsed)){
                        fontsUsedInFrame.push(fontUsed);
                  }    
            }
        }                         
        if (pColors.length > 1){
            errors.push({'type': 'error', 'msg':  'Multiple colors found in text frame.'});
        }else if (pColors.length == 1){
                 for(var c=0;c<=colorsUsed.length;c++){
                    var colorU = colorsUsed[c];
                    if(typeof colorU == 'object' && typeof(colorU.space) != 'undefined' &&  colorU.space.toString() == 'LAB') {
                          errors.push({'type': 'error', 'msg':  'LAB space color used in text frame.' });
                   }
                }
        }
         var borderType = obj.strokeType;
         if(borderType.name.toString() !== 'Solid' && borderType.name.toString() !== 'Durchgezogen'){
            errors.push({'type': 'error', 'msg': borderType.name.toString() + ' border type is not supported.' });
         }
         var borderWeight =  obj.strokeWeight;
         if(obj.strokeWeight > 10){
               errors.push({'type': 'error', 'msg':  'Border weigth is bigger than the supported 10 pt value: ' + borderWeight});
         }
         if(obj.hasOwnProperty ('textFramePreferences')){
                var allowedVerticalAlignements = ['CENTER_ALIGN', 'TOP_ALIGN', 'BOTTOM_ALIGN'];
                if(!inArray(allowedVerticalAlignements, obj.textFramePreferences.verticalJustification.toString() )){
                   errors.push({'type': 'error', 'msg': 'Vertical alignement ' + obj.textFramePreferences.verticalJustification.toString() + ' not supported.'});
               }
         }
        var borderColor = obj.strokeColor;
         if( borderColor instanceof Color &&  borderColor.space.toString()  == "LAB"){
                errors.push({'type': 'error', 'msg':  'LAB space color used as border color.'});
        }
        var frameColor = obj.fillColor;
         if(frameColor instanceof Color && frameColor.space.toString()  == "LAB"){
                errors.push({'type': 'error', 'msg':  'LAB space color used as background color.' });
         }
         var scaleRecY = obj.absoluteVerticalScale;
         var scaleRecX = obj.absoluteHorizontalScale;
          if(scaleRecX < 0){
              errors.push({'type': 'error', 'msg':  'Text frame has a negative horizontal scale of '+ scaleRecX+'.'});
         }
        if(scaleRecY < 0){
                 errors.push({'type': 'error', 'msg':  'Text frame has a negative vertical scale of '+ scaleRecY+'.'});
        }
        if(obj.shearAngle != 0 ) {
            errors.push({'type': 'error', 'msg':  'Text frame '+ obj.id +' is skewed'});
        }  
        if(obj.overflows){
            errors.push({'type': 'error', 'msg':  'Overset text found  in text frame.'});
        }
        if(obj.rectangles.length > 0 || obj.ovals.length > 0 || obj.polygons.length){
            errors.push({'type': 'error', 'msg':  'Objects used in text frame.'});
        }
        if( typeof(obj.textColumns) != "undefined" && obj.textColumns.length > 1){
            errors.push({'type': 'error', 'msg':  'Columns used in textframe.'});
        }
        if(hasKerning >= 1){
             errors.push({'type': 'error', 'msg':  'Kerning used in text frame.'});
        }
       if(hasTextStroke >= 1){
             errors.push({'type': 'error', 'msg':  'Stroked text  in text frame.'});
        }
        if(fontSizes.length > 1){
            errors.push({'type': 'error', 'msg':  'Multiple font sizes applied in text frame .'});
        }
        if(fontsUsedInFrame.length > 1){
            errors.push({'type': 'error', 'msg':  fontsUsedInFrame.length + ' fonts used in text frame. '});
        }
        if(horizonatalAlignements.length > 1){
            errors.push({'type': 'error', 'msg':   'Multiple horizontal alignements used in text frame.'});
        }else if(horizonatalAlignements.length == 1){
                var currentAlignement = horizonatalAlignements[0];
                var allowedAlignements = ['CENTER_ALIGN','LEFT_ALIGN','RIGHT_ALIGN'];
                if(!inArray(allowedAlignements, currentAlignement.toString())){
                      errors.push({'type': 'error', 'msg':  currentAlignement.toString() + ' alignement is not supported.'});
               }
        }
         return errors;               
    }
    function getRectangleErrors(obj, errors){
             var frameColor = obj.fillColor;
             if(frameColor instanceof Color && frameColor.space.toString()  == "LAB"){
               errors.push({'type': 'error', 'msg':  'LAB space color used as background color for  rectangle '});
             }
             var borderColor = obj.strokeColor;
              if(borderColor instanceof Color && borderColor.space.toString()  == "LAB"){
                errors.push({'type': 'error', 'msg':  'LAB space color used as border color for  rectangle '});
             }
             var borderType = obj.strokeType;
             if(borderType.name.toString() !== 'Solid' && borderType.name.toString() !== 'Durchgezogen' || ((borderType.name.toString() == 'Solid' || borderType.name.toString() == 'Durchgezogen')  && obj.strokeWeight > 0)){
                  errors.push({'type': 'error', 'msg': 'Border is not supported for image blocks' });
             }
             var borderWeight =  obj.strokeWeight;
             if(obj.strokeWeight > 10){
                    errors.push({'type': 'error', 'msg':  'Border weigth is bigger than the supported 10 pt value: ' + borderWeight});
             }
             var scaleRecY = obj.absoluteVerticalScale;
             var scaleRecX = obj.absoluteHorizontalScale;
              if(scaleRecX < 0){
                     errors.push({'type': 'error', 'msg':  'Rectangle has a negative horizontal scale of '+ scaleRecX+'.'});
             }
            if(scaleRecY < 0){
                   errors.push({'type': 'error', 'msg':  'Rectangle has a negative vertical scale of '+ scaleRecY+'.'});
             }
             if(typeof(obj.textWrapPreferences.textWrapMode) != "undefined" && obj.textWrapPreferences.textWrapMode  !== TextWrapModes.NONE){
                   errors.push({'type': 'error', 'msg':  'Text wrapped used on rectangle'});
             }
            if(obj.graphics.length == 0){
                 errors.push({'type': 'error', 'msg':  'Rectangle without image found.'});
             }else if(typeof obj.graphics[0] !== "undefined"){
                    if(obj.graphics[0].itemLink.parent instanceof Image == false){
                         errors.push({'type': 'error', 'msg':  'Only Image graphic type allowed in a rectangle.'});
                    }else{
                            if(obj.graphics[0].itemLink.parent.absoluteRotationAngle !== 0 ){
                                 errors.push({'type': 'error', 'msg':  'Image is rotated inside the rectangle.'});
                            }
                             if(obj.frameFittingOptions.rightCrop !== 0 || obj.frameFittingOptions.leftCrop !== 0 || obj.frameFittingOptions.bottomCrop !== 0 || obj.frameFittingOptions.topCrop !== 0){
                                    errors.push({'type': 'error', 'msg':  'Resized image found inside rectangle.'});
                             }
                             if(obj.frameFittingOptions.fittingOnEmptyFrame !== EmptyFrameFittingOptions.FILL_PROPORTIONALLY){
                                    var fitType = '';
                                     if(obj.frameFittingOptions.fittingOnEmptyFrame == "1668575078"){
                                          fitType = "Content To Frame";
                                     }else if(obj.frameFittingOptions.fittingOnEmptyFrame == "1852796517"){
                                           fitType = "None";                                      
                                       }else if(obj.frameFittingOptions.fittingOnEmptyFrame == "1668247152"){
                                             fitType = "Fit Content Proportionally";
                                    }
                                     errors.push({'type': 'error', 'msg':  'Fitting '+ fitType + ' not supported'});
                             }
                             var scaleImgY = obj.graphics[0].itemLink.parent.absoluteVerticalScale;
                             var scaleImgX = obj.graphics[0].itemLink.parent.absoluteHorizontalScale;
                              if(scaleImgX < 0){
                                    errors.push({'type': 'error', 'msg':  'Image has a negative horizontal scale of '+ scaleImgX+'.'});
                             }
                            if(scaleImgY < 0){
                                   errors.push({'type': 'error', 'msg':  'Image has a negative vertical scale of '+ scaleImgY+'.'});
                             }
                             if(obj.graphics[0].itemLink.parent.shearAngle !== 0 || obj.graphics[0].itemLink.parent.parent.shearAngle !== 0 ){
                                 errors.push({'type': 'error', 'msg':  'Image or parent rectangle is skewed'});
                            }
                           
                  }
             }
       return errors;
}
function inArray(array, value){
        if(array.length){
             for(var i=0; i <= array.length; i++){
                    if(array[i] == value){
                            return true;
                   }
           }
       return false;
    }
}
function getFontError(doc){   
        var otf = 0;
        var notInstalled = [];
        var errors= [];
        if(doc.fonts.length){
                var fonts = doc.fonts;
               for(var i=0; i <= fonts.length;fonts++){
                    var font = fonts[i];
                    if(font.status.toString() != "INSTALLED"){
                            notInstalled.push(font.name);
                    }else{
                            if(font.fontType.toString() == 'OPENTYPE_CFF'){
                                    otf++;
                           }
                    }
              }
               if(notInstalled.length ){
                    errors.push({'type':'warning', 'msg': 'Folowing fonts are not installed: ' + notInstalled.join(', ')});
                }
        }
        if(otf > 0){
                if(otf == 1){
                         errors.push({'type':'error', 'msg': otf + ' otf font used in document'});
                }else{
                      errors.push({'type':'error', 'msg': otf + ' otf fonts used in document'});
                }
              
       }
        return errors;
}
function GetSpreadRotation(pageOrSpread) {
  var doc = pageOrSpread.parent;
  if(pageOrSpread instanceof Page){doc=doc.parent}  
 
  var origRulerOrigin = doc.viewPreferences.rulerOrigin;  
  var origZP = doc.zeroPoint;  
  var page = pageOrSpread;  
  if (!(page instanceof Page)){
    page=pageOrSpread.pages[0];  
  }  
  var pageBounds = page.bounds;  
  var retAngle = 0;  
  if(pageBounds[0] == 0 && pageBounds[1] == 0) {  
    retAngle = 0;  
  } else if (pageBounds[0] == 0 && pageBounds[3] == 0) {  
    retAngle = 90;  
  } else if (pageBounds[2] == 0 && pageBounds[3] == 0) {  
    retAngle = 180;  
  } else if (pageBounds[1] == 0 && pageBounds[2] == 0) {  
    retAngle = 270;  
  }  
  return retAngle;  
} 
